const AVAILABLE_ERRORS = [
    'firstname.empty',
    'lastname.empty',
    'compare.not_matched',
    'rate.limit_exceeded',
    'captcha.not_matched',
    'phone_number.invalid',
    'number.invalid',
    'phone.empty',
    'phone_number.empty',
    'captcha.empty',
    'phone_secure.not_found',
    'sms_limit.exceeded',
    'code.empty',
    'code.invalid',
    'confirmations_limit.exceeded',
    'user.not_verified',
    'calls_limit.exceeded',
    'unknowntrack'
];

module.exports = function handleErrors(errors = []) {
    let hasInternal = false;

    return errors.reduce((handledErrors, error) => {
        const isAvailableError = AVAILABLE_ERRORS.indexOf(error) > -1;

        if (isAvailableError) {
            handledErrors.push(error);

            return handledErrors;
        }

        if (!hasInternal) {
            handledErrors.push('internal');
            hasInternal = true;
        }

        return handledErrors;
    }, []);
};
