module.exports = function checkQueryKey(req, res, next) {
    const key = req.nquery && req.nquery.key;

    if (!key) {
        return req._controller.redirectToLocalUrl({
            pathname: 'auth/restore/password'
        });
    }
    return req.api
        .restoreCheckEmailKey({
            key
        })
        .then((response = {}) => {
            const {body = {}} = response;

            res.locals.track_id = body.track_id;
            return next();
        })
        .catch(() => {
            return req._controller.redirectToLocalUrl({
                pathname: 'auth/restore/password'
            });
        });
};
