const apiSetup = require('../../common/apiSetup');
const validateCSRF = require('../../common/validateCSRF');
const writeStatbox = require('../../common/writeStatbox');

module.exports = [
    apiSetup,
    validateCSRF,
    writeStatbox({
        action: 'login_entered',
        mode: 'auth_restore_password_check_login'
    }),
    function checkLogin(req, res) {
        req.api
            .restoreCheckLogin(req.body)
            .then((response = {}) => {
                const {body} = response;

                res.json({status: 'ok', body});
            })
            .catch((error) => {
                res.json({status: 'error', error});
            });
    }
];
