const apiSetup = require('../../../common/apiSetup');
const validateCSRF = require('../../../common/validateCSRF');

module.exports = [
    apiSetup,
    validateCSRF,
    function(req, res, next) {
        req.api
            .restoreCheckHintAnswer(req.body)
            .then((response = {}) => {
                if (response.body && response.body.status === 'ok') {
                    return next();
                }

                return res.json({
                    status: 'error',
                    error: ['internal']
                });
            })
            .catch((error) => res.json({status: 'error', error}));
    },
    function(req, res) {
        req.api
            .restoreGetState({track_id: req.body.track_id})
            .then((response = {}) => {
                const updatedProcessState = (response.body || {}).new_auth_state;

                if (updatedProcessState) {
                    return res.json({
                        status: 'ok',
                        body: {
                            methodsToBind: updatedProcessState.allowed_methods_to_bind,
                            isForcePasswordChange: updatedProcessState.is_forced_password_changing_pending,
                            isNewMethodBindRequired: updatedProcessState.is_method_binding_required,
                            isCheckboxForRevokeShown:
                                updatedProcessState.revokers.allow_select ||
                                updatedProcessState.is_forced_password_changing_pending
                        }
                    });
                }

                return res.json({status: 'error', error: ['internal']});
            })
            .catch((error) => res.json({status: 'error', error}));
    }
];
