const apiSetup = require('../../../common/apiSetup');
const validateCSRF = require('../../../common/validateCSRF');

module.exports = [
    apiSetup,
    validateCSRF,
    function(req, res, next) {
        req.api
            .restoreCheckEmailKey(req.body)
            .then((response = {}) => {
                const {body = {}} = response;

                if (body.status === 'ok') {
                    return next();
                }

                res.json({status: 'error'});
            })
            .catch((error = {}) => {
                return res.json({status: 'error', error});
            });
    },
    function(req, res) {
        req.api
            .restoreGetState({track_id: req.body.track_id})
            .then((response = {}) => {
                const updatedProcessState = (response.body || {}).new_auth_state;

                if (updatedProcessState) {
                    return res.json({
                        status: 'ok',
                        body: {
                            methodsToBind: updatedProcessState.allowed_methods_to_bind,
                            isForcePasswordChange: updatedProcessState.is_forced_password_changing_pending,
                            isNewMethodBindRequired: updatedProcessState.is_method_binding_required,
                            isCheckboxForRevokeShown:
                                updatedProcessState.revokers.allow_select ||
                                updatedProcessState.is_forced_password_changing_pending
                        }
                    });
                }
                return res.json({status: 'error'});
            })
            .catch((error) => {
                return res.json({status: 'error', error});
            });
    }
];
