const url = require('url');
const PLog = require('plog');
const apiSetup = require('../../../common/apiSetup');
const validateCSRF = require('../../../common/validateCSRF');
const config = require('../../../../configs/current');

module.exports = [
    apiSetup,
    validateCSRF,
    function(req, res) {
        req.api
            .sessionCheck({
                session: req.cookies.Session_id || '',
                track_id: req.body.track_id
            })
            .then(function(response = {}) {
                const {body} = response;

                if (body.session_is_correct) {
                    const protocol = req.headers['x-real-scheme'];
                    const mdaCookie = req.cookies.mda;
                    const mdaPathname = '/';
                    const retpath = req.body.retpath;
                    const mdaQuery = {
                        retpath,
                        ncrnd: String(Math.round(Math.random() * 1000000))
                    };

                    let isMDANeeded = false;

                    let pathToRedirect = retpath;

                    if (mdaCookie === '1') {
                        isMDANeeded = true;
                    }

                    if (body.clean) {
                        mdaQuery.clean = body.clean;
                    }

                    if (isMDANeeded) {
                        pathToRedirect = url.format({
                            protocol,
                            hostname: config.paths.mda,
                            pathname: mdaPathname,
                            query: mdaQuery
                        });
                    }

                    req._controller.deleteTrack();

                    return res.json({
                        status: 'ok',
                        retpath: pathToRedirect
                    });
                }

                return res.json({status: 'error', error: ['no_cookie']});
            })
            .catch((error) => {
                PLog.warn()
                    .logId(req.logID)
                    .type('auth restore password')
                    .write(error);

                res.json({
                    status: 'error',
                    error: 'internal'
                });
            });
    }
];
