const apiSetup = require('../../../common/apiSetup');
const validateCSRF = require('../../../common/validateCSRF');
const generateProcessUUID = require('../../../authv2/generateProcessUUID');
const writeStatbox = require('../../../common/writeStatbox');

module.exports = [
    apiSetup,
    validateCSRF,
    generateProcessUUID,
    function preparedStat(req, res, next) {
        res.locals.preparedStat = {
            is_revoke_checkbox_checked: !req.body.revoke_app_passwords
        };

        return next();
    },
    writeStatbox({
        action: 'commit',
        mode: 'restoration_change_password'
    }),
    function(req, res, next) {
        req.api
            .restoreChangePassword(req.body)
            .then((result = {}) => {
                const {body = {}} = result;

                if (body.status === 'ok') {
                    return next();
                }

                return res.json({status: 'error', error: result.body.errors});
            })
            .catch((error) => res.json(error));
    },
    function(req, res) {
        req.api
            .authSubmit('/1/bundle/session/', {track_id: req.body.track_id})
            .then(({body}) => {
                req._controller.augmentResponse(body);

                if (body.cookies) {
                    return res.json({status: 'ok'});
                }

                return res.json({
                    status: 'error',
                    errors: body.errors || []
                });
            })
            .catch((errors) =>
                res.json({
                    status: 'error',
                    errors: errors || []
                })
            );
    }
];
