const apiSetup = require('../../../common/apiSetup');
const validateCSRF = require('../../../common/validateCSRF');

module.exports = [
    apiSetup,
    validateCSRF,
    function(req, res) {
        req.api
            .restoreGetState(req.body)
            .then((response = {}) => {
                const {body = {}} = response;
                const {
                    suitable_restore_methods: restoreMethods = [],
                    restore_finished: isRestorationDone,
                    has_secure_phone_number: hasSecuredNumber,
                    restore_method_passed: isConfirmationDone,
                    new_auth_state: updatedProcessState,
                    state
                } = body;

                if (state) {
                    return res.json({
                        status: 'ok',
                        state
                    });
                }

                if (restoreMethods && !isConfirmationDone) {
                    return res.json({
                        status: 'ok',
                        methods: restoreMethods
                    });
                }

                if (isConfirmationDone && updatedProcessState) {
                    const {
                        new_phone: newPhone,
                        is_new_phone_confirmed: isNewPhoneConfirmed,
                        allowed_methods_to_bind: allowedMethodsToBind
                    } = updatedProcessState;

                    return res.json({
                        status: 'ok',
                        isConfirmationDone,
                        methodsToBind: newPhone && isNewPhoneConfirmed ? [] : allowedMethodsToBind,
                        isForcePasswordChange: updatedProcessState.is_forced_password_changing_pending,
                        isNewMethodBindRequired: updatedProcessState.is_method_binding_required,
                        isCheckboxForRevokeShown:
                            updatedProcessState.revokers.allow_select ||
                            updatedProcessState.is_forced_password_changing_pending,
                        isNewPhoneBound: newPhone && isNewPhoneConfirmed
                    });
                }

                if (isRestorationDone && !hasSecuredNumber) {
                    return res.json({
                        status: 'ok',
                        isBindPhoneSuggested: true
                    });
                }

                return res.json({status: 'error'});
            })
            .catch((error) => res.json({status: 'error', error}));
    }
];
