const apiSetup = require('../../../common/apiSetup');
const validateCSRF = require('../../../common/validateCSRF');
const getRestorationTrack = require('../getRestorationTrack');
const generateProcessUUID = require('../../generateProcessUUID');
const setRestorationUrls = require('../setRestorationUrls');
const config = require('../../../../configs/current');

module.exports = [
    apiSetup,
    validateCSRF,
    generateProcessUUID,
    getRestorationTrack,
    setRestorationUrls,
    (req, res) => {
        req.api
            .restoreLoginsSuggest({track_id: res.locals.track_id})
            .then((result = {}) => {
                const logins = (result.body || {}).suggested_logins || [];

                res.json({
                    trackId: res.locals.track_id,
                    logins: logins
                        .map((item) => item.login)
                        .filter((login) => !login.startsWith(config.neoPhonishPrefix)),
                    urls: res.locals.restorePwdUrls || {}
                });
            })
            .catch((error = {}) => {
                res.json({
                    error
                });
            });
    }
];
