const apiSetup = require('../../../common/apiSetup');
const validateCSRF = require('../../../common/validateCSRF');

module.exports = [
    apiSetup,
    validateCSRF,
    (req, res, next) => {
        req.api
            .restoreSetRestoreMethod(req.body)
            .then(() => {
                return next();
            })
            .catch((error) => res.json({status: 'error', error}));
    },
    (req, res) => {
        req.api
            .restoreGetState(req.body)
            .then((response = {}) => {
                const methodInfo = (response.body || {}).method_state;

                return res.json({
                    status: 'ok',
                    info: methodInfo
                });
            })
            .catch((error) => res.json({status: 'error', error}));
    }
];
