const apiSetup = require('../../../common/apiSetup');
const validateCSRF = require('../../../common/validateCSRF');

module.exports = [
    apiSetup,
    validateCSRF,
    function(req, res) {
        req.api
            .restoreCheckEmail(req.body)
            .then((response = {}) => {
                const {body = {}} = response;

                if (body.status === 'ok') {
                    return res.json({status: 'ok'});
                }

                return res.json({status: 'error', error: response});
            })
            .catch((error) => res.json({status: 'error', error}));
    }
];
