const apiSetup = require('../../common/apiSetup');
const config = require('../../../configs/common');

module.exports = [
    apiSetup,
    (req, res, next) => {
        req.api
            .restoreLoginsSuggest({track_id: res.locals.track_id})
            .then((result = {}) => {
                const restorePasswordStore = res.locals.store && res.locals.store.restorePassword;
                const logins = (result.body || {}).suggested_logins || [];

                if (logins.length >= 1) {
                    restorePasswordStore.logins = logins
                        .map((item) => item.login)
                        .filter((login) => !login.startsWith(config.neoPhonishPrefix));
                }
                return next();
            })
            .catch((error) => {
                return next(error);
            });
    }
];
