const _ = require('lodash');
const apiSetup = require('../../common/apiSetup');

module.exports = [
    apiSetup,
    function(req, res, next) {
        req.api
            .restoreGetState({track_id: res.locals.track_id})
            .then((response = {}) => {
                const {body = {}} = response;
                const {
                    suitable_restore_methods: restoreMethods = [],
                    restore_finished: isRestorationDone,
                    has_secure_phone_number: hasSecuredNumber,
                    new_auth_state: newAuthState,
                    current_restore_method: selectedMethod,
                    user_entered_login: login,
                    restore_method_passed: isConfirmationDone,
                    method_state: methodState
                } = body;
                const storeDraft = res.locals.store || (res.locals.store = {});
                const restoreState = storeDraft.restorePassword || {};
                const authState = storeDraft.auth || {};

                if (selectedMethod === 'semi_auto') {
                    return req._controller.redirectToLocalUrl({
                        pathname: 'auth/restore/password',
                        query: _.omit(req.query, 'track_id')
                    });
                }

                authState.form.login = login;
                authState.mode = 'restore-password';

                if (methodState && methodState.question) {
                    restoreState.methodInfo = {
                        question: methodState.question
                    };
                }

                if (methodState && methodState.phone_entered) {
                    restoreState.number = methodState.phone_entered;
                }

                if (methodState && methodState.email_entered) {
                    restoreState.email = methodState.email_entered;
                }

                if (newAuthState) {
                    const {
                        allowed_methods_to_bind,
                        is_forced_password_changing_pending,
                        is_method_binding_required,
                        new_phone: newPhone,
                        is_new_phone_confirmed: isNewPhoneConfirmed,
                        revokers = {}
                    } = newAuthState;

                    restoreState.processState = {
                        methodsToBind: newPhone && isNewPhoneConfirmed ? [] : allowed_methods_to_bind,
                        isForcePasswordChange: is_forced_password_changing_pending,
                        isNewMethodBindRequired: is_method_binding_required,
                        isCheckboxForRevokeShown: revokers.allow_select,
                        isNewPhoneBound: newPhone && isNewPhoneConfirmed
                    };
                }

                if (selectedMethod) {
                    restoreState.selectedMethod = selectedMethod;
                }

                if (restoreMethods && !isConfirmationDone) {
                    restoreState.isSemiAutoMethodAvailable = restoreMethods.includes('semi_auto');
                    restoreState.methods = restoreMethods;
                }

                if (isRestorationDone) {
                    if (!hasSecuredNumber) {
                        restoreState.isBindPhoneSuggested = true;
                    }

                    restoreState.processState = {
                        isRestorationDone: true
                    };
                }

                return next();
            })
            .catch((error) => next(error));
    }
];
