const apiSetup = require('../../common/apiSetup');
const app_idRe = /^[\S]{0,256}/;

module.exports = [
    apiSetup,
    (req, res, next) => {
        let {app_id} = req.query;

        app_id = typeof app_id === 'string' && app_id.match(app_idRe)[0];

        req.api
            .getTrack({type: 'restore', process: 'restore', app_id})
            .then((result = {}) => {
                res.locals.track_id = (result.body || {}).id;
                return next();
            })
            .catch((error) => {
                return next(error);
            });
    }
];
