const langSetup = require('../../common/langSetup');
const apiSetup = require('../../common/apiSetup');
const getUatraitsData = require('../../common/getUatraitsData');
const rumCounterSetup = require('../../common/rumCounterSetup');
const getSettings = require('../../auth/common/getStore/getSettings');
const getSocial = require('../../auth/common/getStore/getSocial');
const getMetrics = require('../../common/getMetrics');
const getCaptcha = require('../../common/getCaptcha');
const getMonitoring = require('../../auth/common/getStore/getMonitoring');
const createState = require('../../authv2/createState');
const createCommonState = require('../../authv2/createCommonState');
const createCustomsState = require('../../common/createCustomsState');
const getYaExperimentsFlags = require('../../common/getYaExperimentsFlags');
const handleUnsupportedBrowsers = require('./handleUnsupportedBrowsers');
const renderPage = require('../../authv2/renderPage');
const generateProcessUUID = require('../../authv2/generateProcessUUID');
const setRestorationUrls = require('./setRestorationUrls');
const getProcessState = require('./getProcessState');
const checkQueryKey = require('./checkKeyFromEmail');
const processError = require('./processError');
const multiStepAuthStart = require('../../authv2/multiStepAuthStart');

module.exports = [
    apiSetup,
    getUatraitsData,
    handleUnsupportedBrowsers,
    generateProcessUUID,
    langSetup,
    getYaExperimentsFlags,
    createState,
    createCommonState(),
    function(req, res, next) {
        req.api.getTrack().then(function(result) {
            const storeDraft = res.locals.store || (res.locals.store = {});

            storeDraft.common.track_id = result.body.id;
            return next();
        });
    },
    getSettings(),
    getSocial(),
    getCaptcha(),
    getMetrics({
        header: 'Восстановление пароля на авторизации'
    }),
    getMonitoring({
        page: 'auth.v2'
    }),
    createCustomsState,
    checkQueryKey,
    setRestorationUrls,
    (req, res, next) => {
        const storeDraft = res.locals.store || (res.locals.store = {});

        storeDraft.restorePassword = {
            trackId: res.locals.track_id || null,
            isCaptchaRepeatRequired: false,
            methods: [],
            selectedMethod: '',
            logins: [],
            urls: res.locals.restorePwdUrls,
            errors: {}
        };

        storeDraft.auth = {
            isCaptchaRequired: false,
            captchaError: '',
            form: {
                captcha_answer: ''
            }
        };

        return next();
    },
    getProcessState,
    function handleProcessState(req, res, next) {
        const restorePasswordState = (res.locals.store && res.locals.store.restorePassword) || {};
        const processState = restorePasswordState.processState || {};

        if (restorePasswordState.selectedMethod === 'phone') {
            return req._controller.redirectToLocalUrl({
                pathname: '/restoration/2fa',
                query: {
                    track_id: res.locals.track_id
                }
            });
        }

        if (restorePasswordState.selectedMethod === 'hint') {
            res.locals.pagePane = '/auth/restore/password/method';
        }

        if (processState.isNewMethodBindRequired) {
            res.locals.pagePane = '/auth/restore/password/bind-phone';
        }

        return next();
    },
    rumCounterSetup,
    multiStepAuthStart.middleware,
    processError,
    renderPage
];
