const _ = require('lodash');

module.exports = [
    function(error, req, res, next) {
        const storeDraft = res.locals.store || (res.locals.store = {});
        const errorCode = Array.isArray(error) && error[0];
        const codesToRedirect = [
            'track.invalid_state',
            'unknowntrack',
            'account.not_found',
            'user.not_verified',
            'account.global_logout',
            'track_id.empty',
            'track_id.invalid',
            'track.not_found',
            'method.not_allowed',
            'new_method.empty'
        ];

        if (codesToRedirect.includes(errorCode)) {
            return req._controller.redirectToLocalUrl({
                pathname: '/auth/restore/password',
                query: _.omit(req.query, 'track_id')
            });
        }

        storeDraft.restorePassword = {
            trackId: res.locals.track_id || null,
            isCaptchaRepeatRequired: false,
            methods: [],
            selectedMethod: '',
            logins: [],
            urls: res.locals.restorePwdUrls,
            errors: {
                errorCode: error[0] || 'internal'
            }
        };

        storeDraft.auth = {
            isCaptchaRequired: false,
            captchaError: '',
            form: {
                captcha_answer: ''
            }
        };

        return next();
    }
];
