const langSetup = require('../../common/langSetup');
const apiSetup = require('../../common/apiSetup');
const writeStatbox = require('../../common/writeStatbox');
const getUatraitsData = require('../../common/getUatraitsData');
const rumCounterSetup = require('../../common/rumCounterSetup');
const getSettings = require('../../auth/common/getStore/getSettings');
const getSocial = require('../../auth/common/getStore/getSocial');
const getMetrics = require('../../common/getMetrics');
const getCaptcha = require('../../common/getCaptcha');
const getMonitoring = require('../../auth/common/getStore/getMonitoring');
const createState = require('../../authv2/createState');
const createCommonState = require('../../authv2/createCommonState');
const createCustomsState = require('../../common/createCustomsState');
const getYaExperimentsFlags = require('../../common/getYaExperimentsFlags');
const renderPage = require('../../authv2/renderPage');
const generateProcessUUID = require('../../authv2/generateProcessUUID');
const setTheme = require('../../authv2/setTheme');
const handleUnsupportedBrowsers = require('./handleUnsupportedBrowsers');
const getRestorationTrack = require('./getRestorationTrack');
const setRestorationUrls = require('./setRestorationUrls');
const processError = require('./processError');
const getLogins = require('./getLogins');

module.exports = [
    apiSetup,
    getUatraitsData,
    handleUnsupportedBrowsers,
    generateProcessUUID,
    langSetup,
    getYaExperimentsFlags,
    getRestorationTrack,
    function(req, res, next) {
        req.api.getTrack().then(function(result) {
            res.locals.common_track_id = result.body.id;
            return next();
        });
    },
    createState,
    createCommonState(),
    getSettings(),
    getSocial(),
    getCaptcha(),
    getMetrics({
        header: 'Восстановление пароля в домике'
    }),
    getMonitoring({
        page: 'auth.v2.restorePassword'
    }),
    createCustomsState,
    setRestorationUrls,
    (req, res, next) => {
        const storeDraft = res.locals.store || (res.locals.store = {});
        const login = req.query && req.query.login;

        storeDraft.restorePassword = {
            trackId: res.locals.track_id || null,
            isCaptchaRepeatRequired: false,
            methods: [],
            selectedMethod: '',
            logins: [],
            urls: res.locals.restorePwdUrls,
            errors: {}
        };

        storeDraft.auth = {
            isCaptchaRequired: false,
            captchaError: '',
            form: {
                captcha_answer: '',
                login
            },
            processedAccount: {},
            process_uuid: res.locals.process_uuid
        };

        storeDraft.common.track_id = res.locals.common_track_id;

        return next();
    },
    getLogins,
    writeStatbox({
        action: 'opened',
        mode: 'restoration_change_password'
    }),
    rumCounterSetup,
    writeStatbox({
        action: 'opened',
        mode: 'auth_restore_password'
    }),
    processError,
    setTheme,
    renderPage
];
