const PLog = require('plog');
const _ = require('lodash');
const langSetup = require('../../common/langSetup');
const apiSetup = require('../../common/apiSetup');
const getUatraitsData = require('../../common/getUatraitsData');
const rumCounterSetup = require('../../common/rumCounterSetup');
const getSettings = require('../../auth/common/getStore/getSettings');
const getSocial = require('../../auth/common/getStore/getSocial');
const getMetrics = require('../../common/getMetrics');
const getCaptcha = require('../../common/getCaptcha');
const getMonitoring = require('../../auth/common/getStore/getMonitoring');
const createState = require('../../authv2/createState');
const createCommonState = require('../../authv2/createCommonState');
const createCustomsState = require('../../common/createCustomsState');
const getYaExperimentsFlags = require('../../common/getYaExperimentsFlags');
const renderPage = require('../../authv2/renderPage');
const generateProcessUUID = require('../../authv2/generateProcessUUID');
const processError = require('./processError');
const getRestorationTrack = require('./getRestorationTrack');
const setRestorationUrls = require('./setRestorationUrls');
const handleUnsupportedBrowsers = require('./handleUnsupportedBrowsers');

module.exports = [
    apiSetup,
    getUatraitsData,
    function checkLoginProvided(req, res, next) {
        if (req.query.login) {
            return next();
        }

        PLog.warn()
            .logId(req.logID)
            .type('restoration password, captcha generate')
            .write('no login from query string provided, redirecting to auth');

        return req._controller.redirectToLocalUrl({
            pathname: '/auth/restore/password',
            query: _.omit(req.query, 'track_id')
        });
    },
    getRestorationTrack,
    handleUnsupportedBrowsers,
    generateProcessUUID,
    langSetup,
    getYaExperimentsFlags,
    createState,
    createCommonState(),
    getSettings(),
    getSocial(),
    getCaptcha(),
    function(req, res, next) {
        return req.api
            .captchaGenerate({})
            .then((response = {}) => {
                const storeDraft = res.locals.store || (res.locals.store = {});
                const resultStore = storeDraft.captcha || (storeDraft.captcha = {});
                const {body} = response;

                if (body) {
                    const {voice, image_url, key} = body;

                    Object.assign(resultStore, {
                        loading: false,
                        loadingAudio: false,
                        playing: false,
                        type: 'text',
                        key,
                        imageUrl: image_url,
                        introSound: voice.intro_url,
                        captchaSound: voice.url
                    });
                }

                return next();
            })
            .catch(function(errors) {
                PLog.warn()
                    .logId(req.logID)
                    .type('restoration password, captcha generate')
                    .write(errors);

                return next(errors);
            });
    },
    createCustomsState,
    setRestorationUrls,
    function setRestorePasswordState(req, res, next) {
        const storeDraft = res.locals.store || (res.locals.store = {});

        storeDraft.restorePassword = {
            trackId: res.locals.track_id || null,
            isCaptchaRepeatRequired: false,
            methods: [],
            selectedMethod: '',
            logins: [],
            urls: res.locals.restorePwdUrls,
            errors: {}
        };

        storeDraft.auth = {
            isCaptchaRequired: true,
            captchaError: '',
            form: {
                captcha_answer: '',
                login: req.query.login || ''
            }
        };

        return next();
    },
    rumCounterSetup,
    getMetrics({
        header: 'Ввод каптчи'
    }),
    getMonitoring({
        page: 'auth.v2.restorePassword'
    }),
    processError,
    renderPage
];
