const url = require('url');
const _ = require('lodash');

module.exports = function setRestorationUrls(req, res, next) {
    const currentUrlObj = url.parse(url.format(req._controller.getUrl()), true);
    const trackId = res.locals.track_id;

    res.locals.restorePwdUrls = {
        notify: url.parse(
            url.format(
                Object.assign({}, currentUrlObj, {
                    search: null,
                    pathname: '/auth/restore/password/notify',
                    query: Object.assign({}, _.omit(currentUrlObj.query, 'track_id'))
                })
            )
        ).path,
        start: url.parse(
            url.format(
                Object.assign({}, currentUrlObj, {
                    search: null,
                    pathname: '/auth/restore/password',
                    query: Object.assign({}, _.omit(currentUrlObj.query, 'track_id'))
                })
            )
        ).path,
        method: url.parse(
            url.format(
                Object.assign({}, currentUrlObj, {
                    search: null,
                    pathname: '/auth/restore/password/method',
                    query: Object.assign({}, _.omit(currentUrlObj.query, 'track_id'))
                })
            )
        ).path,
        methodConfirm: url.parse(
            url.format(
                Object.assign({}, currentUrlObj, {
                    search: null,
                    pathname: '/auth/restore/password/method-confirm',
                    query: Object.assign({}, _.omit(currentUrlObj.query, 'track_id'))
                })
            )
        ).path,
        finish: url.parse(
            url.format(
                Object.assign({}, currentUrlObj, {
                    search: null,
                    pathname: '/auth/restore/password/finish',
                    query: Object.assign({}, _.omit(currentUrlObj.query, 'track_id'))
                })
            )
        ).path,
        captcha: url.parse(
            url.format(
                Object.assign({}, currentUrlObj, {
                    search: null,
                    pathname: '/auth/restore/password/captcha',
                    query: Object.assign({}, _.omit(currentUrlObj.query, 'track_id'))
                })
            )
        ).path,
        bindPhone: url.parse(
            url.format(
                Object.assign({}, currentUrlObj, {
                    search: null,
                    pathname: '/auth/restore/password/bind-phone',
                    query: Object.assign({}, _.omit(currentUrlObj.query, 'track_id'))
                })
            )
        ).path,
        bindHint: url.parse(
            url.format(
                Object.assign({}, currentUrlObj, {
                    search: null,
                    pathname: '/auth/restore/password/bind-hint',
                    query: Object.assign({}, _.omit(currentUrlObj.query, 'track_id'))
                })
            )
        ).path,
        bindPhoneConfirm: url.parse(
            url.format(
                Object.assign({}, currentUrlObj, {
                    search: null,
                    pathname: '/auth/restore/password/bind-phone-confirm',
                    query: Object.assign({}, _.omit(currentUrlObj.query, 'track_id'))
                })
            )
        ).path,
        restorationForm: url.parse(
            url.format(
                Object.assign({}, currentUrlObj, {
                    search: null,
                    pathname: '/restoration/fallback',
                    query: Object.assign({}, currentUrlObj.query, {
                        track_id: trackId,
                        process_uuid: res.locals.process_uuid
                    })
                })
            )
        ).path,
        restoration2FA: url.parse(
            url.format(
                Object.assign({}, currentUrlObj, {
                    search: null,
                    pathname: '/restoration/twofa',
                    query: Object.assign({}, currentUrlObj.query, {
                        track_id: trackId
                    })
                })
            )
        ).path
    };

    return next();
};
