module.exports = function setRestorePasswordState(req, res, next) {
    const login = req.query && req.query.login;
    const storeDraft = res.locals.store || (res.locals.store = {});

    storeDraft.restorePassword = {
        trackId: res.locals.track_id || null,
        isCaptchaRepeatRequired: false,
        methods: [],
        selectedMethod: '',
        logins: [],
        urls: res.locals.restorePwdUrls,
        errors: {}
    };

    storeDraft.auth = {
        isCaptchaRequired: false,
        captchaError: '',
        form: {
            captcha_answer: '',
            login
        },
        mode: 'restore-password'
    };

    return next();
};
