const _ = require('lodash');

module.exports = function setTrack(req, res, next) {
    const trackId = req.query && req.query.track_id;

    if (trackId) {
        res.locals.track_id = trackId;
        return next();
    }

    return req._controller.redirectToLocalUrl({
        pathname: 'auth',
        query: _.omit(req.query, 'track_id')
    });
};
