const passportApiSetup = require('../common/passportApiSetup');
const langSetup = require('../common/langSetup');
const validateCSRF = require('../common/validateCSRF');
const encodeEmailDomain = require('./encodeEmailDomain');
const PLog = require('plog');

module.exports = [
    langSetup,
    passportApiSetup,
    validateCSRF,
    encodeEmailDomain,
    (req, res) => {
        const {
            email,
            retpath,
            uid,
            track_id: trackId,
            code_only: codeOnly,
            validator_ui_url: validatorUIUrl
        } = req.body;

        req._passportApi
            .sendConfirmationEmail({
                email,
                retpath,
                uid,
                validatorUIUrl,
                trackId,
                codeOnly
            })
            .then(() => res.json({status: 'ok'}))
            .catch((errors) => {
                PLog.warn()
                    .logId(req.logID)
                    .type('auth.new.sendConfirmationEmail')
                    .write(errors);

                return res.json(errors._response);
            });
    }
];
