module.exports = function setAuthButtonAndTextExperiment(req, res, next) {
    const experimentsFlags = (res.locals.experiments && res.locals.experiments.flags) || [];
    const storeDraft = res.locals.store || (res.locals.store = {});
    const resultStore = storeDraft.auth || (storeDraft.auth = {});

    const experimentRegex = /^domik-buttonandtext-exp([1-4])$/;
    const experiment = experimentsFlags.find((flag) => experimentRegex.test(flag));

    if (!experiment) {
        return next();
    }

    resultStore.isAuthButtonAndTextExp = true;
    resultStore.authButtonAndTextExperimentNumber = Number(experiment.replace(experimentRegex, '$1'));

    return next();
};
