const isNeoPhonishRegisterAvailable = require('../common/isNeoPhonishRegisterAvailable');
const isRegisterInDaHouseAvailable = require('../common/isRegisterInDaHouseAvailable');

module.exports = function setPreRegisterExperiment(req, res, next) {
    const {origin} = req.query;
    const experimentsFlags = (res.locals.experiments && res.locals.experiments.flags) || [];
    const storeDraft = res.locals.store || (res.locals.store = {});
    const resultStore = storeDraft.auth || (storeDraft.auth = {});
    const forcedByNeoPhonish = isNeoPhonishRegisterAvailable(experimentsFlags, origin);
    const forcedByOrigin = isRegisterInDaHouseAvailable(origin);

    resultStore.isRegisterWithSuggestToRestoreByPhoneInDaHouse =
        experimentsFlags.includes('register-with-suggest-to-restore-by-phone-in-da-house') ||
        forcedByOrigin ||
        forcedByNeoPhonish;

    return next();
};
