module.exports = (req, res, next) => {
    const themeQueryParam = req.query && req.query.theme;
    const theme = themeQueryParam || req._controller.getCookie('theme');

    if (theme) {
        const store = res.locals.store || (res.locals.store = {});

        store.settings.theme = theme;

        if (themeQueryParam) {
            req._controller.setCookie('theme', theme);
        }
    }

    return next();
};
