const passportApiSetup = require('../common/passportApiSetup');
const langSetup = require('../common/langSetup');
const validateCSRF = require('../common/validateCSRF');
const encodeEmailDomain = require('./encodeEmailDomain');
const PLog = require('plog');

module.exports = [
    langSetup,
    passportApiSetup,
    validateCSRF,
    encodeEmailDomain,
    (req, res) => {
        const {email, uid, is_safe: isSafe} = req.body;

        req._passportApi
            .setupConfirmedEmail(email, isSafe, uid)
            .then(() => res.json({status: 'ok'}))
            .catch((errors) => {
                PLog.warn()
                    .logId(req.logID)
                    .type('auth.new.setupConfirmedEmail')
                    .write(errors);

                return res.json(errors._response);
            });
    }
];
