const modeValidators = {
    phoneconfirm(queryParams = {}) {
        return Boolean(queryParams.uid);
    }
};

function validateParams(queryParams = {}) {
    const {mode, app_platform: appPlatform} = queryParams;

    return (
        ['ios', 'android'].includes(appPlatform) && (modeValidators[mode] ? modeValidators[mode](queryParams) : true)
    );
}

module.exports = function validateAMParams(req, res, next) {
    const {pathname} = req._controller.getUrl() || {};

    if (/^\/am(\/.*)?$/.test(pathname) && !validateParams(req.query)) {
        res.redirect('/am/finish?status=error');

        return;
    }

    next();
};
