const apiSetup = require('../common/apiSetup');
const validateCSRF = require('../common/validateCSRF');
const handleErrors = require('./restoreLogin/handleErrors');
const getCountry = require('../common/getCountry');

module.exports.route = [
    apiSetup,
    validateCSRF,
    getCountry,
    (req, res) => {
        const params = Object.assign({}, req.body, {
            country: res.locals.country || 'ru'
        });

        req.api
            .validatePhoneV2(params)
            .then((result) => res.json(result.body || result))
            .catch((errors) =>
                res.json({
                    status: 'error',
                    errors: handleErrors(errors)
                })
            );
    }
];
