const apiSetup = require('../common/apiSetup');
const validateCSRF = require('../common/validateCSRF');
const handleErrors = require('./restoreLogin/handleErrors');

module.exports.route = [
    apiSetup,
    validateCSRF,
    (req, res) => {
        const {phoneId, track_id: trackId} = req.body;

        req.api
            .validatePhoneById({phoneId, trackId})
            .then((result) => res.json(result.body || result))
            .catch((errors) =>
                res.json({
                    status: 'error',
                    errors: handleErrors(errors)
                })
            );
    }
];
