var url = require('url');
var apiSetup = require('./common/apiSetup');
var config = require('../configs/current');

exports.routes = {};

exports.route = function(app) {
    var routes = this.routes;
    var pddRoute = '/for/:pdd_domain*';

    app.all(
        '/passport/?',
        function(req, res, next) {
            if (req.nquery && req.nquery.mode === 'autologin') {
                return next();
            }

            return next('route');
        },
        routes.main
    );

    app.all(
        pddRoute,
        function(req, res, next) {
            if (req.nquery && req.nquery.mode === 'autologin') {
                return next();
            }

            return next('route');
        },
        routes.main
    );
};

exports.routes.main = [
    function(req, res) {
        return res.redirect('https://moikrug.ru/users/sign_in');
    },
    apiSetup,
    doAutoLogin
];

exports.getConfig = function() {
    return config;
};

function doAutoLogin(req, res) {
    var data = {
        track_id: req.body.key || (req.nquery && req.nquery.key),
        retpath: req.body.retpath || (req.nquery && req.nquery.retpath)
    };
    const controller = req._controller;

    req.api.authSubmit('/1/bundle/auth/autologin/', data).done(
        function(results) {
            var body = results.body;
            var target = url.format({
                protocol: req.headers['x-real-scheme'],
                hostname: req.hostname,
                pathname: 'passport',
                query: {
                    mode: 'passport'
                }
            });
            var finishPathname;

            if (body.cookies && body.cookies.length) {
                finishPathname = '/auth/finish/';

                controller.augmentResponse(body);

                target = url.format({
                    protocol: req.headers['x-real-scheme'],
                    hostname: req.hostname,
                    pathname: finishPathname,
                    query: {
                        track_id: body.track_id
                    }
                });
            } else if (body.retpath) {
                target = body.retpath;
            }

            return res.redirect(target);
        },
        function() {
            return res.redirect(
                url.format({
                    protocol: req.headers['x-real-scheme'],
                    hostname: req.hostname,
                    pathname: '/auth/',
                    query: {
                        retpath: data.retpath
                    }
                })
            );
        }
    );
}

exports.doAutoLogin = doAutoLogin;
