const url = require('url');
const config = require('../../configs/current');
const PLog = require('plog');
const LangSwitcherView = require('../../blocks/layout/LangSwitcherView');
const isIntranet = process.env.INTRANET === 'intranet';
const isUnsupportedBro = require('../common/isUnsupportedBro');

module.exports = function createState(req, res, next) {
    // eslint-disable-line
    const langSwitcher = new LangSwitcherView(req._controller);
    const locals = res.locals;
    const account = locals.account || {};
    const defaultAccount = (locals.accounts || {}).defaultAccount || {};
    const tld = req._controller.getTld();
    const yandexuid = res._yandexuid && res._yandexuid.replace(/[^0-9]/g, '');
    const displayNamesList = (locals.displaynameInfo || {}).displayNamesSuggest || {};
    const defaultRetpath = `https://yandex.${tld}`;
    const query = req.query;
    const {metricsUserType} = locals.userType || {};
    const {paths = {}, version} = config;
    const avatarPaths = paths.avatar;
    const {blackbox: {connection_id: ci = ''} = {}} = req;

    let queryUid = '';

    if (query && query.uid) {
        queryUid = query.uid.replace(/[^0-9]/g, '');
    }

    res.locals.uid = queryUid || (locals.accounts && locals.accounts.defaultAccount.uid);

    locals.store = {
        settings: {
            version,
            metricsUserType,
            isNewLayout: true,
            host: url.format({
                protocol: req.headers['x-real-scheme'],
                hostname: req.hostname
            }),
            avatar: config.paths.avatar || {},
            staticPath: config.paths.static,
            links: isIntranet ? config.links.intranet : config.links[tld] || config.links.ru || {},
            help: config.paths.help || {},
            tld,
            language: locals.language,
            ua: locals.ua || {},
            env: {
                type: process.env.NODE_ENV,
                name: process.env.INTRANET
            },
            isPopupMode: query && query.mode === 'popup',
            accountsUrl: config.paths.accountsUrl
        },
        common: {
            csrf: locals.csrf,
            uid: queryUid || (locals.accounts && locals.accounts.defaultAccount.uid),
            experiments: res.locals.experiments,
            process_uuid: res.locals.process_uuid,
            login: locals.accounts && locals.accounts.defaultAccount.login,
            yandexuid,
            track_id: locals.track_id,
            retpath: locals.validRetpath || defaultRetpath,
            currentPage: req._controller.getUrl().href,
            defaultPage: url.format({
                pathname: '/profile/public',
                query: req.query
            }),
            isPDD: account.domain !== undefined,
            actionForRepeat: null,
            mode: 'public_avatar_displayname'
        },
        avatar: {
            track_id: locals.avatarsTrack || null,
            default_300: avatarPaths.default_300,
            avatarSize_300: avatarPaths.avatar_300.replace('%avatar_id%', defaultAccount.avatarId),
            avatarPrev: '',
            isProcessing: false,
            isLoading: false,
            fileType: 'jpeg',
            compression: 0.6,
            isCropNotSupported: isUnsupportedBro(locals.ua),
            error: ''
        },
        displayName: {
            value: defaultAccount.publicDisplayName || '',
            publicDisplayName: defaultAccount.publicDisplayName,
            suggestedPublicName: defaultAccount.suggestedPublicName,
            suggestedNames: Object.keys(displayNamesList).filter((name) => name !== defaultAccount.publicDisplayName),
            filteredSuggestedNames: [],
            displayNamesList,
            error: '',
            isProcessing: false,
            isLoading: false
        },
        dashboard: {
            plus: Object.assign(
                {},
                {
                    country: locals.country,
                    allowed: locals.showPlus,
                    enabled: false
                },
                defaultAccount.plus
            )
        },
        form: {},
        header: {
            accounts: (locals.accounts && locals.accounts.accounts) || [],
            defaultAccount,
            canAddMore: locals.accounts && locals.accounts['can-add-more'],
            ci
        },
        footer: {
            langlist: []
        },
        metrics: {
            header: 'Страница смены аватара и дисплейнейма'
        },
        monitoring: {
            page: 'public_avatar_displayname'
        }
    };

    langSwitcher
        ._compile()
        .then(function(response) {
            const langlist = (response && response.langlist) || {};

            locals.store.footer.langlist = langlist;
        })
        .catch(function(error) {
            PLog.warn()
                .logId(req.logID)
                .type('profile.getdata, langSwitcher')
                .write(error);
        })
        .done(function() {
            delete locals.account;
            delete locals.accounts;
            return next();
        });
};
