const express = require('express');
const router = express.Router();
const PLog = require('plog');
const url = require('url');
const langSetup = require('./common/langSetup');
const multiAuthAccountsSetup = require('./common/multiAuthAccountsSetup').getAccounts;
const apiSetup = require('./common/apiSetup');
const getUatraitsData = require('./common/getUatraitsData');
const writeStatbox = require('./common/writeStatbox');
const generateProcessUUID = require('./authv2/generateProcessUUID');
const checkAuth = require('./common/checkAuth');
const showPlus = require('./common/plusGuard').showPlus;
const validateCSRF = require('./common/validateCSRF');
const rumCounterSetup = require('./common/rumCounterSetup');
const createState = require('./avatar-displayname/createState');
const validateRetpath = require('./common/validateRetpath');
const getYaExperimentsFlags = require('./common/getYaExperimentsFlags');
const getMetrics = require('./common/getMetrics');

const enter = [
    apiSetup,
    checkAuth,
    getYaExperimentsFlags,
    getUatraitsData,
    langSetup,
    rumCounterSetup,
    function getTrack(req, res, next) {
        req.api
            .getTrack({}, true)
            .then(function(result) {
                res.locals.track_id = result.body.track_id;
                return next();
            })
            .catch((error) => {
                PLog.warn()
                    .logId(req.logID)
                    .type('avatar-displayname, getTrack')
                    .write(error);
                return next();
            });
    },
    function getAvatarsTrack(req, res, next) {
        req.api
            .genericAvatar('/1/change_avatar/init/')
            .then((response = {body: {}}) => {
                res.locals.avatarsTrack = response.body.track_id;
                return next();
            })
            .catch((error) => {
                PLog.warn()
                    .logId(req.logID)
                    .type('avatar-displayname, getAvatarsTrack')
                    .write(error);
                return next();
            });
    },
    generateProcessUUID,
    validateRetpath,
    showPlus,
    function(_req, res, next) {
        if (res.locals.showPlus) {
            res.locals.blackboxPlus = true;
        }

        return next();
    },
    multiAuthAccountsSetup,
    checkQueryUidLoginParams,
    createState,
    (req, res, next) => {
        const {body = {}} = req;
        const {locals = {}} = res;
        const {store = {}, userType = {}} = locals;
        const {isPortal} = userType;
        const {displayname} = body;
        const isPublicIdEnabled = req.query && ['publicid'].includes(req.query.origin); // TODO need origin
        const defaultAccount = (store.header || {}).defaultAccount;

        if (displayname && store.displayName) {
            store.displayName.value = displayname;
        }

        store.publicId = {
            hasUpdated: false,
            publicIdSuggest: [],
            showLoginInSuggest: isPortal,
            updatesNumber: 0
        };

        store.publicAccess = {
            hasPublicProfile: defaultAccount.hasPublicProfile,
            hasThirdPartyAccess: defaultAccount.hasThirdPartyAccess,
            isPopupVisible: false
        };

        if (isPublicIdEnabled) {
            store.publicId.isEnabled = true;
            store.publicId.isOpened = false;
            store.publicId.isEmbedded = true;
            store.publicId.hasPublicIdSet = defaultAccount.hasPublicIdSet;
        }

        return next();
    },
    (req, res, next) => {
        res.locals.isPopupMode = req.query && req.query.mode === 'popup';

        return next();
    },
    writeStatbox({
        action: 'opened',
        mode: 'public_avatar_displayname'
    }),
    getMetrics({
        header: 'Страница смены аватара и дисплейнейма'
    }),
    renderPage
];

const updateDisplayName = [
    apiSetup,
    getYaExperimentsFlags,
    function(req) {
        req.body.force_clean_web = true;

        req.api.profileUpdate(req.body).then(
            () => req._controller.redirectToFrontpage(),
            () => req._controller.redirectToFrontpage()
        );
    }
];

router.get('/', enter);
router.post('/', enter);
router.post('/displayname', updateDisplayName);

function renderPage(req, res) {
    const lang = res.locals.language;

    res.removeHeader('X-Frame-Options');
    res.render(`react.avatar-displayname.${lang}.jsx`);
}

function getAccountInfo(req, res) {
    const params = {
        need_display_name_variants: true,
        need_phones: false,
        need_emails: false,
        need_social_profiles: false,
        need_question: false,
        need_additional_account_data: false
    };

    req.api
        .profileGetState(params)
        .then((response) => {
            if (response && response.body) {
                const account = response.body.account || {};
                const {display_name, display_names, public_id} = account;

                return res.json({
                    status: 'ok',
                    publicId: public_id,
                    displaynameInfo: {
                        displayName: (display_name || {}).name || '',
                        displayNamesSuggest: display_names
                    }
                });
            }

            return res.json({status: 'error'});
        })
        .catch((error) => {
            PLog.warn()
                .logId(req.logID)
                .type('avatar-displayname, getAccountInfo')
                .write(error);
            return res.json({status: 'error'});
        });
}

exports.router = router;
exports.getDisplaynameData = [apiSetup, validateCSRF, getAccountInfo];

function checkQueryUidLoginParams(req, res, next) {
    const queryLogin = req.query && req.query.login;
    const queryUid = req.query && req.query.uid;

    if (queryLogin || queryUid) {
        const blackBoxRequestParams = queryLogin ? {login: queryLogin} : {uid: queryUid};

        return req._controller
            .getAuth()
            .userInfo(blackBoxRequestParams)
            .then(function(userinfo = {}) {
                const {uid, login} = userinfo;
                const defaultAccount = (res.locals.accounts || {}).defaultAccount || {};

                if (defaultAccount.uid !== uid.value) {
                    const retpathToProfile = url.format({
                        protocol: req.headers['x-real-scheme'],
                        hostname: req.hostname,
                        pathname: '/profile/public',
                        query: req.query
                    });
                    const authUrlQuery = {
                        retpath: retpathToProfile
                    };

                    if (uid.value) {
                        authUrlQuery.uid = uid.value;
                    }

                    if (login) {
                        authUrlQuery.login = login;
                    }

                    PLog.info()
                        .logId(req.logID)
                        .type('avatar-displayname, checkQueryUidLoginParams')
                        .write("Redirecting to auth: query login/uid !== default user's login/uid");
                    return req._controller.redirectToLocalUrl({
                        pathname: 'auth/add',
                        query: authUrlQuery
                    });
                }

                return next();
            })
            .catch(function(error) {
                if (error && error.code === 'need_resign') {
                    return req._controller.getAuth().resign();
                }

                return next();
            });
    }

    return next();
}
