const PLog = require('plog');
const langSetup = require('./common/langSetup');
const multiAuthAccountsSetup = require('./common/multiAuthAccountsSetup').getAccounts;
const apiSetup = require('./common/apiSetup');
const getUatraitsData = require('./common/getUatraitsData');
const writeStatbox = require('./common/writeStatbox');
const checkAuth = require('./common/checkAuth');
const getYaExperimentsFlags = require('./common/getYaExperimentsFlags');
const getMetrics = require('./common/getMetrics');
const rumCounterSetup = require('./common/rumCounterSetup');
const generateProcessUUID = require('./authv2/generateProcessUUID');
const createState = require('./registration/createAvatarState');
const validateRetpath = require('./common/validateRetpath');

module.exports = [
    apiSetup,
    checkAuth,
    getUatraitsData,
    langSetup,
    function getAvatarsTrack(req, res, next) {
        req.api
            .genericAvatar('/1/change_avatar/init/')
            .then((response = {body: {}}) => {
                res.locals.avatarsTrack = response.body.track_id;
                return next();
            })
            .catch((error) => {
                PLog.warn()
                    .logId(req.logID)
                    .type('avatar-displayname, getAvatarsTrack')
                    .write(error);
                return next();
            });
    },
    generateProcessUUID,
    validateRetpath,
    getYaExperimentsFlags,
    multiAuthAccountsSetup,
    createState,
    writeStatbox({
        action: 'opened',
        mode: 'registration_avatar'
    }),
    getMetrics({header: 'Дозапрос аватара после регистрации'}),
    rumCounterSetup,
    renderPage
];

function renderPage(req, res) {
    const lang = res.locals.language;

    res.render(`react.avatar-registration.${lang}.jsx`);
}
