const PLog = require('plog');
const config = require('../configs/current');
const {urlFormat} = require('./common/urlFormat');
const langSetup = require('./common/langSetup');
const apiSetup = require('./common/apiSetup');
const getSocial = require('./auth/common/getStore/getSocial');
const getUatraitsData = require('./common/getUatraitsData');
const writeStatbox = require('./common/writeStatbox');
const checkAuth = require('./common/checkAuth');
const rumCounterSetup = require('./common/rumCounterSetup');
const LangSwitcherView = require('../blocks/layout/LangSwitcherView');
const validateRetpath = require('./common/validateRetpath');
const getYaExperimentsFlags = require('./common/getYaExperimentsFlags');
const getMetrics = require('./common/getMetrics');
const createFormState = require('./common/createFormState');
const createCustomsState = require('./common/createCustomsState');
const setTheme = require('./authv2/setTheme');
const providers = require('./common/providers.json');

const express = require('express');
const router = express.Router();
const {env = {}} = process;
const {INTRANET, NODE_ENV} = env;
const SAFETY_REGEXP = /[^0-9]/g;

const enter = [
    apiSetup,
    checkAuth,
    getYaExperimentsFlags,
    getUatraitsData,
    langSetup,
    rumCounterSetup,
    validateRetpath,
    (req, res, next) => {
        const {locals = {}} = res;
        const {query = {}, hostname} = req;
        const {
            language,
            ua = {},
            track_id,
            userType = {},
            regionId,
            countryId,
            experiments,
            validRetpath: retpath,
            csrf,
            country
        } = locals;
        const {uid} = query;
        const {paths = {}, version} = config;
        const langSwitcher = new LangSwitcherView(req._controller);
        const protocol = req.headers['x-real-scheme'];
        const {static: staticPath} = paths;
        const {metricsUserType} = userType;
        const tld = req._controller.getTld();
        const profilePage = urlFormat({...req._controller.getUrl(), pathname: '/profile'});

        locals.store = {
            settings: {
                version,
                metricsUserType,
                staticPath,
                host: urlFormat({
                    protocol,
                    hostname
                }),
                embeddedauth: paths.embeddedauth || '',
                soundManagerPath: paths.soundManager,
                help: paths.help || {},
                tld,
                language,
                country,
                ua,
                env: {
                    type: NODE_ENV,
                    name: INTRANET
                },
                regionId,
                countryId
            },
            common: {
                uid: (uid || '').replace(SAFETY_REGEXP, ''),
                yandexuid: res._yandexuid && res._yandexuid.replace(SAFETY_REGEXP, ''),
                track_id,
                retpath: retpath || profilePage,
                experiments,
                currentPage: req._controller.getUrl().href,
                profilePage,
                actionForRepeat: null,
                dev: config.dev,
                csrf,
                loadCustomsStyles: true
            },
            footer: {
                langlist: []
            }
        };

        langSwitcher
            ._compile()
            .then((response = {}) => {
                const {langlist = {}} = response;

                locals.store.footer.langlist = langlist;
                return next();
            })
            .catch((error) => {
                PLog.warn()
                    .logId(req.logID)
                    .type('common.createState, langSwitcher')
                    .write(error);
            });
    },
    getSocial(),
    createCustomsState,
    function getPageData(req, res, next) {
        const retpath =
            res.locals.validRetpath ||
            urlFormat({
                hostname: req.hostname,
                pathname: '/profile'
            });

        req.api
            .profileGetState()
            .then((result = {}) => {
                const tld = req._controller.getTld();
                const getEditDataLink = (page) =>
                    urlFormat({...req._controller.getUrl(), pathname: `/profile/${page}`});
                const {body = {}} = result;
                const {account = {}} = body;
                const {person = {}, profiles = [], phones = {}, emails = {}, display_name = {}, question} = account;
                const phone = Object.values(phones).find((phone) => phone.secured);

                res.locals.store.personalInfo = {
                    avatar: `${config.paths.mds}/get-yapic/${display_name.default_avatar}/islands-200`,
                    name: (person && `${person.firstname} ${person.lastname}`) || null,
                    phone: phone ? phone.number.masked_international : null,
                    email:
                        emails.suitable_for_restore && emails.suitable_for_restore.length
                            ? emails.suitable_for_restore
                            : null,
                    social: getSocialProvidersList(profiles, tld),
                    question: question ? question.text : null,
                    links: {
                        name: getEditDataLink('personal-info'),
                        phone: getEditDataLink('phones'),
                        email: getEditDataLink('emails/list'),
                        social: getEditDataLink('social'),
                        question: getEditDataLink('change-hint')
                    }
                };

                return next();
            })
            .catch((error) => {
                PLog.warn()
                    .logId(req.logID)
                    .type('check-data, getPageData')
                    .write(error);
                return req._controller.redirect(retpath);
            });
    },
    createFormState,
    writeStatbox({
        action: 'opened',
        mode: 'check-data'
    }),
    getMetrics({
        header: 'Страница check-data'
    }),
    setTheme,
    function renderPage(req, res) {
        res.render(`react.check-data.${res.locals.language}.jsx`);
    }
];

function getSocialProvidersList(profiles = [], tld = 'ru') {
    const providersToDomainList = (providers.domains || []).find((provider) => provider.tld === tld);
    const providersIdList = (providersToDomainList.providers || []).map((item) => item.id);

    if (!profiles.length) {
        return null;
    }

    return profiles
        .filter((profile = {}) => providersIdList.includes((profile.provider || {}).id))
        .map((profile) => {
            const {provider_code, username, person} = profile;

            return {
                provider: provider_code,
                name: person.firstname ? `${person.firstname} ${person.lastname}` : username
            };
        });
}

router.get('/', enter);
exports.router = router;
