var fs = require('fs');
var PLog = require('plog');
var apiSetup = require('../common/apiSetup');

exports.route = function(app) {
    app.get('/registration-validations/transparent.png/?', [
        apiSetup,
        function(req, res) {
            var dataForTrack = {
                track_id: req.query['id'],
                language: 'ru',
                check_css_load: true
            };

            req.api
                .writeTrack(dataForTrack)
                .then(function() {
                    try {
                        var streamImg = fs.createReadStream('./routes/checkcssload/transparent-pixel.png');

                        streamImg.on('error', function(e) {
                            PLog.warn()
                                .logId(req.logID)
                                .type('checkcssload_error-read-stream')
                                .write(e);
                            res.end();
                        });

                        res.writeHead(200, {'Content-Type': 'image/png'});
                        streamImg.pipe(res);
                    } catch (e) {
                        PLog.warn()
                            .logId(req.logID)
                            .type('checkcssload_error-on-response')
                            .write(e);
                        res.status(403).json({});
                    }
                })
                .catch(function(e) {
                    PLog.warn()
                        .logId(req.logID)
                        .type('checkcssload_write-track-error')
                        .write(e);
                    res.status(403).json({});
                });
        }
    ]);
};
