const {SERVICE_ALIASES} = require('../../lib/tvm');
const AfishaApi = require('../../lib/api/afisha');

const afishaApiSetup = (req, res, next) => {
    if (req.afishaApi) {
        return next();
    }

    const controller = req._controller;

    const userTicket = req.userTicket;
    const afishaTicket = req.serviceTickets && req.serviceTickets[SERVICE_ALIASES.AFISHA];
    const userVariables = {
        city: req.userCity || null,
        region: controller.getTld(),
        geoid: res.locals.regionId,
        lang: res.locals.language,
        userIp: req.header('x-real-ip'),
        userAgent: req.header('user-agent'),
        yandexuid: req.cookies.yandexuid
    };

    req.afishaApi = new AfishaApi(req.logID, userTicket, afishaTicket, userVariables);
    return next();
};

module.exports = afishaApiSetup;
