var api = require('../../lib/passport-api');
var _ = require('lodash');

var TLD_RE = /.*.yandex\.(.*)$/;

module.exports = function setup(req, res, next) {
    if (req.api) {
        return next();
    }

    var query = req.nquery || req.query || {};
    var body = req.body;

    api.client({
        ...req,
        track_id: body.track_id || query.track_id,
        language: body.language || query.language,
        country: body.country || query.country
    })
        .then(function(a) {
            var tld = TLD_RE.exec(req.hostname);

            _.assign(
                res.locals,
                {
                    domain: (tld && tld[1]) || 'ru'
                },
                a.locals()
            );

            req.api = a;

            next();
        })
        .catch(function(error) {
            next(error);
        });
};
