const AvatarsApi = require('../../lib/api/avatars');
const tvm = require('../../lib/tvm');

module.exports = (req, res, next) => {
    if (req._avatarsAPI) {
        return next();
    }

    return req._controller
        .getAuth()
        .sessionID()
        .then(() => {
            const serviceTicket = req.serviceTickets && req.serviceTickets[tvm.SERVICE_ALIASES.AVATARS];

            req._avatarsAPI = new AvatarsApi(req.logID, serviceTicket);

            return next();
        });
};
