const PLog = require('plog');

function captchaGenerate(logType = 'common.captchaGenerate') {
    return (req, res, next) =>
        req.api
            .captchaGenerate({})
            .then((response) => {
                res.locals.result = {...(res.locals.result || {}), ...{captchaGenerate: response.body}};

                return next();
            })
            .catch(function(errors) {
                PLog.warn()
                    .logId(req.logID)
                    .type(logType)
                    .write(errors);

                return next();
            });
}

module.exports = {
    captchaGenerate
};
