const isValid = require('./isValid');

module.exports = (req) =>
    new Promise((resolve, reject) => {
        const controller = req._controller;
        const auth = controller.getAuth();

        auth.sessionID({
            multisession: 'yes',
            full_info: 'yes',
            get_family_info: 'yes',
            get_public_id: 'yes',
            get_public_name: 'yes',
            allow_child: 'yes',
            emails: 'getdefault',
            // @see https://wiki.yandex-team.ru/passport/dbmoving/#tipyatributov
            attributes: '27,28,32,34,1003,1005,1011',
            aliases: '1,5,6,13,21'
        })
            .then((sessionInfo) => {
                if (isValid(sessionInfo)) {
                    return resolve({
                        status: 'ok'
                    });
                }

                return reject({
                    status: 'error'
                });
            })
            .catch((err) => {
                if (err && err.code === 'need_resign') {
                    return resolve({
                        status: 'ok'
                    });
                }

                return reject({
                    status: 'error',
                    error: err
                });
            });
    });
