const getDefaultUser = require('./getDefaultUser');

module.exports = function(sessionInfo) {
    if (!sessionInfo) {
        return false;
    }

    const users = sessionInfo.users;
    const defaultUid = sessionInfo.default_uid;
    const defaultUser = getDefaultUser(users, defaultUid);

    if (
        typeof defaultUid !== 'undefined' &&
        defaultUser &&
        defaultUser.status &&
        defaultUser.status.value !== 'INVALID' &&
        defaultUser.status.value !== 'DISABLED'
    ) {
        return true;
    }

    return false;
};
