const CloudApi = require('../../lib/api/cloud');
const tvm = require('../../lib/tvm');

module.exports = (req, res, next) => {
    if (req._cloudAPI) {
        return next();
    }

    return req._controller
        .getAuth()
        .sessionID()
        .then((session) => {
            const uid = session && session.uid && session.uid.value;
            const serviceTicket = req.serviceTickets && req.serviceTickets[tvm.SERVICE_ALIASES.CLOUD];
            const userTicket = req.userTicket && req.userTicket[tvm.SERVICE_ALIASES.CLOUD];

            req._cloudAPI = new CloudApi(req.logID, uid, serviceTicket, userTicket);

            return next();
        });
};
