function createCSRFValidator(onSuccess, onError) {
    return function validateCSRF(req, res, next) {
        var controller = req._controller;

        controller
            .isCsrfTokenValidV2(req.body.csrf_token)
            .then(function(isValid) {
                if (isValid) {
                    return onSuccess(req, res, next);
                }

                return onError(req, res, next);
            })
            .catch(function() {
                return onError(req, res, next);
            });
    };
}

module.exports = createCSRFValidator;
