const isNeoPhonishRegisterAvailable = require('../common/isNeoPhonishRegisterAvailable');
const getCustomConfigByRequest = require('./getCustomConfigByRequest');
const putCustomsFieldsInStore = require('./putCustomsFieldsInStore');
const getOriginByOtherParams = require('./getOriginByOtherParams');

module.exports = function createCustomsState(req, res, next) {
    const storeDraft = res.locals.store || (res.locals.store = {});
    const {query = {}, body = {}} = req;
    const origin = getOriginByOtherParams(req) || storeDraft.common.origin || query.origin || body.origin;
    const social = req.query.social || req.body.social;
    const resultStore = storeDraft.customs || (storeDraft.customs = {});
    const {experiments: {flags = []} = {}, language} = res.locals;
    const hasOrigin = Boolean(origin && typeof origin === 'string');

    putCustomsFieldsInStore(
        hasOrigin && getCustomConfigByRequest(req),
        storeDraft,
        isNeoPhonishRegisterAvailable(flags, origin),
        flags,
        language
    );

    if (hasOrigin) {
        storeDraft.common.origin = origin;

        if (/^music_|^music$|^radio$/.test(origin)) {
            resultStore.socialScope = {
                fb: 'user_friends,user_birthday,public_profile,email,user_likes',
                vk: 'offline,audio,friends'
            };

            if (storeDraft.social && Array.isArray(storeDraft.social.providers)) {
                storeDraft.social.providers.forEach((provider) => {
                    if (provider.id === 6) {
                        provider.primary = false;
                    }
                });
            }
        }
    }

    if (social === 'extended') {
        resultStore.socialExtended = true;
    }

    return next();
};
