const handlePhoneCallExperiment = require('../registration/handlePhoneCallExperiment');
const lookup = require('../../lib/getLookup.js');

const IS_TESTING_OR_DEV = ['testing', 'development'].includes(process.env.NODE_ENV);

module.exports = (req, res, next) => {
    let questionList = [];
    const locals = res.locals;
    const {formErrors = [], captchaErrors = [], questions, experiments, language, regionId} = locals;
    const {query = {}, body = {}} = req;
    const isDebug = IS_TESTING_OR_DEV && (query.debug === '1' || body.debug === '1');

    if (questions && Array.isArray(questions) && questions.length > 1) {
        questionList = questions.slice(1).map((question, index) => ({
            id: `q${index}`,
            val: question.id,
            text: question.value
        }));
    }

    locals.store = Object.assign(
        {},
        {
            form: {
                type: 'alternative',
                activeField: '',
                formErrors,
                captchaErrors,
                validation: {
                    method: 'phone',
                    phoneConfirmationType: 'sms',
                    humanConfirmationDone: false,
                    isValidPhoneForCall: false,
                    magicConfirmationCode: '',
                    callConfirmationTimer: null,
                    isCallConfirmationInProcess: false,
                    isForceCheckedConfirmationCode: false,
                    confirmationCodeLength: 0
                },
                states: {
                    firstname: '',
                    lastname: '',
                    login: '',
                    password: '',
                    password_confirm: '',
                    hint_question_id: 'valid',
                    hint_question: 'valid',
                    hint_question_custom: 'valid',
                    hint_answer: '',
                    captcha: '',
                    phone: '',
                    phoneCode: '',
                    phoneCodeStatus: '',
                    gender: 'valid',
                    birthday: ''
                },
                values: {
                    firstname: query.firstname || body.firstname || (isDebug && 'John') || '',
                    lastname: query.lastname || body.lastname || (isDebug && 'Doe') || '',
                    surname: '',
                    login: query.login || '',
                    password: '',
                    password_confirm: '',
                    hint_question_id: '',
                    hint_question: '',
                    hint_question_custom: '',
                    hint_answer: '',
                    captcha: '',
                    phone: query.phone_number || body.phone_number || (isDebug && '+7 (900) 000-00-00') || '',
                    phoneCode: '',
                    publicId: '',
                    gender: 'm',
                    birthday: ''
                },
                errors: {
                    active: '',
                    firstname: {
                        code: '',
                        text: ''
                    },
                    lastname: {
                        code: '',
                        text: ''
                    },
                    login: {
                        code: '',
                        text: ''
                    },
                    password: {
                        code: '',
                        text: ''
                    },
                    password_confirm: {
                        code: '',
                        text: ''
                    },
                    hint_question_id: {
                        code: '',
                        text: ''
                    },
                    hint_question: {
                        code: '',
                        text: ''
                    },
                    hint_question_custom: {
                        code: '',
                        text: ''
                    },
                    hint_answer: {
                        code: '',
                        text: ''
                    },
                    captcha: {
                        code: '',
                        text: ''
                    },
                    phone: {
                        code: '',
                        text: ''
                    },
                    phoneCode: {
                        code: '',
                        text: ''
                    },
                    phoneCodeStatus: '',
                    birthday: {
                        code: '',
                        text: ''
                    }
                },
                humanConfirmation: {
                    isCaptchaRequired: false,
                    questionList,
                    isFetching: false
                },
                isEulaCheckedByDefault: true,
                isEulaShowedInPopup: false,
                captchaRequired: false,
                canSwitchConfirmationMethod: false,
                isPhoneCallConfirmationAvailable: false,
                isForcePhoneCallConfirmation: false,
                isDiscardCallConfirmation: false,
                isPhoneCanBePrefilled: false,
                keepUnsubscribedValue: false
            }
        },
        res.locals.store
    );

    if (questionList.length) {
        locals.store.form.values.hint_question = questionList[0].text;
        locals.store.form.values.hint_question_id = questionList[0].val;
    }

    if (experiments) {
        const experimentFlags = experiments.flags;

        if (Array.isArray(experimentFlags)) {
            Object.assign(locals.store.form, handlePhoneCallExperiment(experimentFlags, language));
        }
    }

    try {
        const isRUDomain = req._controller.getTld() === 'ru';
        const isRegionRussia =
            regionId !== undefined && lookup.getCountryId(regionId, req._controller.getTld()) === 225;

        if (!isRegionRussia || !isRUDomain) {
            locals.store.form.isEulaShowedInPopup = true;
            locals.store.form.isEulaCheckedByDefault = false;
        }

        if (isRegionRussia && isRUDomain) {
            locals.store.form.isPhoneCanBePrefilled = true;
        }
    } catch (e) {
        locals.store.form.isEulaShowedInPopup = true;
        locals.store.form.isEulaCheckedByDefault = false;
    }

    next();
};
