const PLog = require('plog');
const RegController = require('../../lib/controller/RegistrationController');

module.exports = function createSession(req, res) {
    const registrationController = new RegController(req, res, req.logID);

    return registrationController
        .createSession() // TODO replace outdated API /1/session/ to /1/bundle/session/
        .then(function() {
            return res.json({status: 'ok'});
        })
        .catch(function(error) {
            const sessionError = [{field: 'global', code: 'sessionidoverflow'}];

            PLog.warn()
                .logId(req.logID)
                .type('registration.v2')
                .write('createSession ', error);

            return res.json({status: 'error', error: sessionError});
        });
};
