const PLog = require('plog');
const RegController = require('../../lib/controller/RegistrationController');

module.exports = function createSessionWithoutAJAX(req, res, next) {
    const registrationController = new RegController(req, res, req.logID);

    return registrationController
        .createSession() // TODO replace outdated API /1/session/ to /1/bundle/session/
        .then(function() {
            return registrationController.redirectToFinish(req.body.track_id);
        })
        .catch(function(error) {
            const sessionError = [{field: 'global', code: 'sessionidoverflow'}];

            PLog.warn()
                .logId(req.logID)
                .type('registration.v2')
                .write('createSession ', error);

            res.locals.formErrors = sessionError;
            next();
        });
};
