const uuid = require('uuid');
const isNeoPhonishRegisterAvailable = require('../common/isNeoPhonishRegisterAvailable');
const config = require('../../configs/current');

const getRegistrationMode = ({pathname = '', experiments, origin}) => {
    const {flags = []} = experiments;
    const isNeoPhonishRegister = isNeoPhonishRegisterAvailable(flags, origin);

    let mode = 'simple';

    if (pathname.includes('/reg') || pathname.includes('/am')) {
        mode = 'with-suggest-to-restore-by-phone';

        if (isNeoPhonishRegister) {
            mode = 'neophonish';
        }
    }

    if (pathname.includes('/browser')) {
        mode = 'browser';
    }

    return mode;
};

module.exports = [
    (req, res, next) => {
        const {track_id: registerTrackId, experiments = {}} = res.locals;
        const {origin} = req.query;

        res.locals.store = Object.assign(
            {},
            {
                registrationErrors: {
                    status: 'ok',
                    code: '',
                    text: ''
                },
                signup: {
                    mode: getRegistrationMode({pathname: req.path, experiments, origin}),
                    tmxSession: uuid.v4(),
                    config: config.signup
                },
                tracks: {
                    registerTrackId
                },
                settings: {
                    formUrl: '/registration'
                }
            },
            res.locals.store
        );

        next();
    }
];
