const url = require('url');
const _ = require('lodash');
const PLog = require('plog');
const LangSwitcherView = require('../../blocks/layout/LangSwitcherView');
const config = require('../../configs/current');
const getPassportLinks = require('./getPassportLinks');
const apiRequest = require('../authv2/apiRequest.js');
const isFamilyEnable = require('./isFamilyEnable');
const getDefaultUser = require('./checkAuth/getDefaultUser');
const {env = {}} = process;
const {INTRANET, NODE_ENV} = env;
const SAFETY_REGEXP = /[^0-9]/g;

module.exports = [
    apiRequest('validateRetpath'),
    (req, res, next) => {
        const {locals = {}} = res;
        const {query = {}, hostname} = req;
        const {
            account = {},
            accounts = {},
            language,
            ua = {},
            track_id,
            userType = {},
            regionId,
            countryId,
            experiments,
            result: apiRequestsResult = {}
        } = locals;
        const {defaultAccount = {}} = accounts;
        const {
            person = {},
            display_name: displayName = {},
            display_login: displayLogin,
            display_names: displayNames = {},
            is_2fa_enabled: is2faEnabled,
            password_info: passwordInfo = {}
        } = account;
        const {strong_policy_on: isPasswordStrongPolicy} = passwordInfo;
        const {city = '', birthday = ''} = person;
        const {uid} = query;
        const {paths = {}, links = {}, version} = config;
        const langSwitcher = new LangSwitcherView(req._controller);
        const tld = req._controller.getTld();
        const yandexuid = res._yandexuid && res._yandexuid.replace(SAFETY_REGEXP, '');
        const protocol = req.headers['x-real-scheme'];
        const {static: staticPath} = paths;
        const {metricsUserType} = userType;
        const {blackbox: {connection_id: ci = ''} = {}} = req;

        let queryUid = '';

        if (uid) {
            queryUid = uid.replace(SAFETY_REGEXP, '');
        }

        let retpath;

        if (apiRequestsResult.validateRetpath && apiRequestsResult.validateRetpath.retpath) {
            retpath = apiRequestsResult.validateRetpath.retpath;
        }

        let attributes = {};

        if (req.blackbox) {
            const {default_uid: defaultUid, users} = req.blackbox;
            const defaultUser = getDefaultUser(users, defaultUid);

            if (defaultUser && defaultUser.attributes) {
                attributes = defaultUser.attributes;
            }
        }

        locals.store = {
            ...locals.store,
            settings: {
                isNewLayout: true,
                version,
                metricsUserType,
                staticPath,
                host: url.format({
                    protocol,
                    hostname
                }),
                avatar: paths.avatar || {},
                embeddedauth: paths.embeddedauth || '',
                soundManagerPath: paths.soundManager,
                links: INTRANET === 'intranet' ? links.intranet : links[tld] || links.ru || {},
                passportLinks: getPassportLinks(req),
                help: paths.help || {},
                tld,
                language,
                country: locals.country,
                ua,
                env: {
                    type: NODE_ENV,
                    name: INTRANET
                },
                regionId,
                countryId,
                accountsUrl: config.paths.accountsUrl,
                isTouch: ua.isMobile || ua.isTouch
            },
            common: {
                uid: queryUid || defaultAccount.uid,
                login: defaultAccount.login,
                yandexuid,
                track_id,
                retpath,
                experiments,
                currentPage: req._controller.getUrl().href,
                defaultPage: url.format({
                    pathname: '/profile',
                    query
                }),
                profilePage: url.format(
                    Object.assign(req._controller.getUrl(), {
                        pathname: '/profile'
                    })
                ),
                profile_url: url.format({
                    pathname: '/profile',
                    query
                }),
                emailValidatorUiUrl: url.format({
                    protocol,
                    hostname,
                    pathname: '/registration-validations/email/confirm-by-link'
                }),
                isFamilyEnable: isFamilyEnable(countryId),
                isPDD: account.domain !== undefined,
                actionForRepeat: null,
                dev: config.dev
            },
            access: {
                isSms2faEnabled: attributes['200'] === '1',
                isAppPasswordsEnabled: account.app_passwords_enabled,
                is2faEnabled,
                isPasswordStrongPolicy,
                hasQuestion: Boolean(account.question)
            },
            header: {
                accounts: accounts.accounts || [],
                defaultAccount: accounts.defaultAccount || {},
                canAddMore: accounts['can-add-more'],
                ci
            },
            person: Object.assign({}, person, {
                city,
                uid: account.uid,
                login: account.login,
                displayLogin,
                birthday,
                avatarId: displayName.default_avatar || '',
                displayNames,
                displayName: displayName.name || '',
                escapedDisplayName: _.escape(displayName.name) || '',
                errors: {},
                loginOptions: {
                    qrCodeLoginForbidden: Boolean(attributes[182]),
                    smsCodeLoginForbidden: Boolean(attributes[187])
                },
                isSocialchik: defaultAccount.isSocial,
                havePassword: defaultAccount.havePassword,
                isLiteUser: defaultAccount.is_liteUser,
                isPDD: defaultAccount.isPDD,
                isSuperLiteUser: defaultAccount.is_liteUser && !defaultAccount.havePassword,
                isNeoPhonish: defaultAccount.isNeoPhonish
            }),
            footer: {
                langlist: []
            },
            tracks: {
                commonTrackId: track_id
            }
        };

        langSwitcher
            ._compile()
            .then((response = {}) => {
                const {langlist = {}} = response;

                locals.store.footer.langlist = langlist;

                delete locals.account;
                delete locals.accounts;

                return next();
            })
            .catch(function(error) {
                PLog.warn()
                    .logId(req.logID)
                    .type('common.createState, langSwitcher')
                    .write(error);
            });
    }
];
