const getYaExperimentsFlags = require('./getYaExperimentsFlags');

exports.route = (app) => {
    app.get('/info/debug', [
        getYaExperimentsFlags,
        (req, res) => {
            res.locals.cookieMy = req.cookies['my'] || null;
            res.locals.headers = {};

            ['host', 'x-real-ip', 'accept-language'].forEach(function(key) {
                res.locals.headers[key] = req.headers[key] || '-';
            });

            if (res.locals.headers.cookie) {
                delete res.locals.headers.cookie;
            }

            req._controller.getLangdetect().then(function(response) {
                res.locals.lg = response;
                res.render('common.debug.ru.js');
            });
        }
    ]);
};
